package org.msh.tb.export_rest.core;

import org.jboss.seam.international.LocaleSelector;
import org.msh.tb.application.tasks.AsyncTaskImpl;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Asynchronous task to export data to an Excel file. This task is triggered by
 * the {@link ExcelExportAsyncService} service
 * <p>
 * Created by rmemoria on 14/7/17.
 */
public class ExcelExportTask extends AsyncTaskImpl {

    public static final String PARAM_EXCEL_FILE = "excelFile";
    public static final String PARAM_MASTER_READER = "masterReader";
    public static final String PARAM_EXCEL_EXPORT_SERVICE = "excelExportService";
    public static final String PARAM_CHILD_READERS = "childReaders";


    @Override
    protected void starting() {
        String loc = (String) getParameter("locale");
        if (loc != null) {
            LocaleSelector.instance().setLocaleString(loc);
        }
    }

    @Override
    protected void execute() {
        File excelFile = (File) getParameter(PARAM_EXCEL_FILE);
        BlockReader masterReader = (BlockReader) getParameter(PARAM_MASTER_READER);
        List<BlockReader> readers = (List<BlockReader>) getParameter(PARAM_CHILD_READERS);
        ExcelExportService service = (ExcelExportService) getParameter(PARAM_EXCEL_EXPORT_SERVICE);

        try {
            service.export(excelFile, masterReader, readers, new ExcelExportListener() {
                @Override
                public boolean onProgress(double position) {
                    setProgress(position);
                    return isCanceling() ? false : true;
                }
            });
        } catch (IOException e) {
            getLogger().error("Error when trying to export to Excel");
            throw new ExcelExportException(e);
        }


        if (!isCanceling()) {
            addlogData(excelFile.toString());
        }
    }

    @Override
    protected void finishing() {

    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isLogged() {
        return true;
    }
}
